<?php
session_start();
require_once './config/config.php';
require_once './includes/auth_validate.php';


//serve POST method, After successful insert, redirect to products.php page.
if ($_SERVER['REQUEST_METHOD'] === 'POST') 
{
    //Mass Insert Data. Keep "name" attribute in html form same as column name in mysql table.
    $data_to_store = array_filter($_POST);

    //Get Image 
    $imageUploadOk = 1;
    $target_dir = "../uploads/";
    $imageName = date('Y-m-d-H-i-s-') . basename($_FILES["image"]["name"]);
    $target_file = $target_dir . $imageName;
    $imageFileType = strtolower(pathinfo($target_file,PATHINFO_EXTENSION));
    $check = getimagesize($_FILES["image"]["tmp_name"]);
    // Image validations
    if (file_exists($target_file)) {
        echo "Sorry, Image already exists.";
        $imageUploadOk = 0;
        exit();
    }
    if($check === false) {
        echo "File is not an image.";
        $imageUploadOk = 0;
        exit();
    }
    if ($_FILES["image"]["size"] > 500000) {
        echo "Sorry, your Image is too large, Image size exceed 5kb";
        $imageUploadOk = 0;
        exit();
    }
    if($imageFileType != "jpg" && $imageFileType != "JPG" && $imageFileType != "png" && $imageFileType != "PNG" && $imageFileType != "jpeg" && $imageFileType != "JPEG" && $imageFileType != "gif" && $imageFileType != "GIF") {
        echo "Sorry, only JPG, JPEG, PNG & GIF files are allowed.";
        $imageUploadOk = 0;
        exit();
    }
    if ($imageUploadOk == 0) {
        echo "Sorry, your Image was not uploaded.";
        exit();
    } else {
        if (move_uploaded_file($_FILES["image"]["tmp_name"], $target_file)) {
            echo "The Image ". htmlspecialchars( basename( $_FILES["image"]["name"])). " has been uploaded.";
        } else {
            echo "Sorry, there was an error uploading your Image.";
            exit();
        }
    }
    //Insert Image in database
    $data_to_store['image'] = $imageName;

    //Insert timestamp
    // $data_to_store['created_at'] = date('Y-m-d H:i:s');
    $db = getDbInstance();
    
    // echo '<pre>'; echo print_r($data_to_store); die;
    $last_id = $db->insert('products', $data_to_store);

    if($last_id)
    {
    	$_SESSION['success'] = "Product added successfully!";
    	header('location: all_products.php');
    	exit();
    }
    else
    {
        echo 'insert failed: ' . $db->getLastError();
        exit();
    }
}

//We are using same form for adding and editing. This is a create form so declare $edit = false.
$edit = false;

require_once 'includes/header.php'; 
?>
<div id="page-wrapper">
<div class="row">
     <div class="col-lg-12">
            <h2 class="page-header">Add Products</h2>
        </div>
        
</div>
    <form class="form" action="" method="post"  id="product_form" enctype="multipart/form-data">
       <?php  include_once('./forms/product_form.php'); ?>
    </form>
</div>


<script type="text/javascript">
$(document).ready(function(){
   $("#product_form").validate({
       rules: {
            product_id: {
                required: true,
                minlength: 2
            },
            name: {
                required: true,
                minlength: 3
            },   
        }
    });
});
</script>

<?php include_once 'includes/footer.php'; ?>